/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.util;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import satisfyu.beachparty.registry.SoundEventRegistry;

@OnlyIn(value=Dist.CLIENT)
public class RadioHelper {
    private static final Map<BlockPos, List<SimpleSoundInstance>> soundInstances = new HashMap<BlockPos, List<SimpleSoundInstance>>();

    public static void setPlaying(BlockPos pos, int channel, boolean play, int delay) {
        if (play) {
            if (!soundInstances.containsKey(pos)) {
                RadioHelper.addSounds(pos);
            }
            RadioHelper.playSound(pos, channel, delay);
        } else {
            RadioHelper.stopSounds(pos);
        }
    }

    public static void tune(BlockPos pos, int channel) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance((SoundEvent)SoundEventRegistry.RADIO_TUNE.get(), SoundSource.RECORDS, 1.0f, 1.0f, RandomSource.m_216327_(), pos));
        RadioHelper.stopSounds(pos);
        if (!soundInstances.containsKey(pos)) {
            RadioHelper.addSounds(pos);
        }
        RadioHelper.playSound(pos, channel, 40);
    }

    private static void playSound(BlockPos pos, int channel, int delay) {
        SimpleSoundInstance soundInstance = RadioHelper.getSound(pos, channel);
        if (soundInstance != null) {
            Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)soundInstance, delay);
        }
    }

    private static void stopSounds(BlockPos pos) {
        if (soundInstances.containsKey(pos)) {
            for (SimpleSoundInstance soundInstance : soundInstances.get(pos)) {
                Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)soundInstance);
            }
        }
    }

    private static void addSounds(BlockPos blockPos) {
        ArrayList soundInstance = Lists.newArrayList();
        for (RegistrySupplier<SoundEvent> sound : SoundEventRegistry.RADIO_SOUNDS) {
            soundInstance.add(new SimpleSoundInstance(((SoundEvent)sound.get()).m_11660_(), SoundSource.RECORDS, 1.0f, 1.0f, RandomSource.m_216327_(), true, 0, SoundInstance.Attenuation.LINEAR, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), false));
            soundInstances.put(blockPos, soundInstance);
        }
    }

    public static SimpleSoundInstance getSound(BlockPos pos, int channel) {
        return soundInstances.get(pos).get(channel);
    }
}

